/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: x509CMSMemoryFuncs.c,v 1.5 2001/01/25 22:11:38 jeffc Exp $
____________________________________________________________________________*/
#include "x509CMS.h"

#include "pgpMemoryMgr.h"

PKIMemoryMgr X509CMSMemoryMgr = {
    NULL,
    x509CMSAllocProc,
    x509CMSReallocProc,
    x509CMSDeallocProc
};

void *
x509CMSAllocProc (
        PKIMemoryMgr    *mem,
        size_t          requestSize
)
{
    return (PGPNewData ((PGPMemoryMgrRef) mem->customValue, requestSize, 0)); 
}

int
x509CMSDeallocProc (
        PKIMemoryMgr    *mem,
        void            *allocation
)
{
	(void) mem;
	
	/* PGPFreeData asserts on null */
	if( allocation )
		PGPFreeData (allocation);
    return 0;
}

int
x509CMSReallocProc (
	PKIMemoryMgr	*mem,
	void		**allocation,
	size_t		requestSize)
{
    PGPReallocData ((PGPMemoryMgrRef) mem->customValue, allocation, requestSize, 0);
    return 0;
}
